/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件为绘制点位图
 * 备注：
 *      使用时需载入JQ
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.12.22
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_bitmap */
/* global $ */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    绘制点位图
 * 参数:
 *    @param { Promise<Array> } arr_dot 绘制图形数据列表
 *    @param { Promise<Number> } ui_w
 *    @param { Promise<Number> } ui_h
 *    @param { Promise<Number> } ui_sx
 *    @param { Promise<Number> } ui_sy
 * 参数备注：
 *    图形数据列表每项
 *    obj_data = {
 *       x:Number,
 *       y:Number,
 *       w:Number,
 *       h:Number,
 *       rotate:Number,
 *       scalex:Number,
 *       scaley:Number,
 *       mirror:Number 1=水平 2= 镜像（暂不使用）
 *    }
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2021.12.22
 *      内容 : 所有代码
 *************************************************************************************************/
function mc_bitmap(arr_dot,ui_w,ui_h,ui_sx,ui_sy) {
    //生成的图片名称
    var imgName = "screen.bmp";
    var canvas = document.createElement("canvas");
    var context = canvas.getContext("2d");
    var scale = 1;
    var color = "#008000";

    canvas.width = ui_w * scale;
    canvas.height = ui_h * scale;
    canvas.style.width = ui_w + "px";
    canvas.style.height = ui_h + "px";
    context.scale(scale, scale);
    // 绘制图形 缩放-旋转-镜像

    for (var index = 0; index < arr_dot.length; index++) {
        var obj_data = arr_dot[index];
        var x = obj_data.x - ui_sx;
        var y = obj_data.y - ui_sy;
        var w = obj_data.w;
        var h = obj_data.h;

        context.save();
        context.fillStyle = color;
        if (obj_data.rotate) {
            // if (1 === obj_data.mirror) {
            //     context.translate(x + 0.5 * w + w, y + 0.5 * h);
            //     context.scale(-obj_data.scalex,obj_data.scaley);
            // } else if (2 === obj_data.mirror) {
            //     context.translate(x + 0.5 * w, y + 0.5 * h + h);
            //     context.scale(obj_data.scalex,-obj_data.scaley);
            // } else {
            context.translate(x + 0.5 * w, y + 0.5 * h);
            context.scale(obj_data.scalex,obj_data.scaley);
            // }
            context.rotate(obj_data.rotate * Math.PI / 180);
            context.fillRect(-0.5 * w, -0.5 * h, w, h);
        } else {
            // if (1 === obj_data.mirror) {
            //     context.translate(obj_data.w, 0);
            //     context.scale(-obj_data.scalex,obj_data.scaley);
            // } else if (2 === obj_data.mirror) {
            //     context.translate(0,obj_data.h);
            //     context.scale(obj_data.scalex,-obj_data.scaley);
            // } else {
            context.scale(obj_data.scalex,obj_data.scaley);
            // }
            context.fillRect(x, y, w, h);
        }
        context.restore();
    }

    context.imageSmoothingEnabled = false;
    context.webkitImageSmoothingEnabled = false;
    context.msImageSmoothingEnabled = false;
    context.imageSmoothingEnabled = false;
    var dataUrl = canvas.toDataURL("image/jpeg", 1.0);
    var binStr = atob(dataUrl.split(",")[1]);
    var len = binStr.length;
    var arr = new Uint8Array(len);

    for (var i = 0; i < len; i++) {
        arr[i] = binStr.charCodeAt(i);
    }

    var triggerDownload = $("<a>").attr("href", URL.createObjectURL(new Blob([arr]))).attr("download", imgName).appendTo("body").on("click", function () {
        if (navigator.msSaveBlob) {
            return navigator.msSaveBlob(new Blob([arr]), imgName);
        }
        return "";
    });

    triggerDownload[0].click();
    triggerDownload.remove();
}


